//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Parameters
//:
//: Functions can accept values. We refer to them as the parameters of the function.
//:
//: Each parameter needs:
//: * An argument label
//: * A parameter name
//: * Type annotation specifying the type
//:
//: Execute the code below. The function declares two parameters which are combined and then returned.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func functionName(label1 paramName1: String, label2 paramName2: String) -> String {
    return paramName1 + ", " + paramName2
}
let returnedValue = functionName(label1: "argument 1", label2: "argument 2")
print(returnedValue)


//:
//: -------------------
//:
//: Using one name results in it representing both the labels and parameter names.
//:
//: This is simpler, less code and easier to read.
//:
//: -------------------
//:


func functionName2(paramName1: String, paramName2: String) -> String {
    return paramName1 + ", " + paramName2
}
let returnedValue2 = functionName2(paramName1: "argument 1", paramName2: "argument 2")
print(returnedValue2)


//:
//: -------------------
//:
//: We might specify different argument labels to increase readability or describe the behaviour of the function.
//:
//: Execute the code below.
//:
//: -------------------
//:

func generateEmailBody(nameOfSender sender: String, nameOfRecipient recipient: String) -> String {
    """
    Hello \(recipient),
    my name is \(sender). How are you?
    We have a very special one time offer for you.
    Please respond to this email if you are interested in hearing more.
    """
}
let email = generateEmailBody(nameOfSender: "Bob", nameOfRecipient: "Roxette")
print(email)


//:
//: -------------------
//:
//: ## Task:
//:
//: The extra argument labels in the code above don't appear to add more clarity or help better describe the purpose of the code.
//:
//: Go back and remove the labels, leaving only one name for each input parameter.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
//: It's not always helpful to include any argument label.
//:
//: Sometimes the name of the function already describes the purpose of the first input parameter.
//:
//: In Swift we can replace an argument label with an underscore (`_`). This removes the label and leaves only the value passed in.
//:
//: -------------------
//:


func function(_ param1: String, label2 param2: String) -> String {
    return param1 + ", " + param2
}
let anotherReturnedValue = function("argument 1", label2: "argument 2")
print(anotherReturnedValue)


//:
//: -------------------
//:
//: Be careful though!
//:
//: This won't help document or explain the intended behaviour for each parameter. Your colleagues may not be impressed using functions they cannot understand.
//:
/*:
 
 */
//: ## Task:
//:
//: Edit the code below.
//:
//: Using an underscore remove both labels from calling the function below.
//:
//: -------------------
//:


func generateEmailBody2(sender: String, recipient: String) -> String {
    """
    Hello \(recipient),
    my name is \(sender). How are you?
    We have a very special one time offer for you.
    Please respond to this email if you are interested in hearing more.
    """
}
let email2 = generateEmailBody2(sender: "Bob", recipient: "Roxette") // who is the sender and who is the recipient?
print(email2)


//:
//: -------------------
//:
//: We recommend using labels unless the name of the function already implies the intended use for the first parameter.
//:
//: Execute the code below.
//:
//: -------------------
//:


func signEmailBody(_ body: String, sendersName sender: String) -> String {
    """
    \(body)
    Kind Regards
    \(sender)
    Thank you for contacting company ABC.
    www.ABC.com
    For customer suppport contact customer-support@abc.com
    """
}
let sender = "Bob"
let unsignedEmailBody = generateEmailBody(nameOfSender: sender, nameOfRecipient: "Roxette")
let emailBody = signEmailBody(unsignedEmailBody, sendersName: sender)
print(emailBody)


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a function to accept a users personal details and set each value in a tuple.
//:
//: In a new function accept this tuple as an input parameter and return a multiline string printout of this persons details.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here










